#include <time.h>
#include "../common/debug.h"
#include "../common/colors.h"
#include "../common/buffer.h"
#include "normal_renderer.h"
#include "ray_common.h"
#include "tracer.h"
#include "../shader/post_shaders.h"
#include "../common/misc.h"

extern scene_data* main_scene;
extern int intersects_calced;

/* traces all rays from camera.  uses high level access to buffer */
void normal_render()
{
	int i, j;
	intersect_data *id;
	color c;

	printd(1, "entering render loop\n");

	for(j=0; j<main_scene->height; j++)
	{
		for(i=0; i<main_scene->width; i++)
		{
			id = (intersect_data*)get_idata(i,j);
			calc_ray(i,j);
			id->obj->shader(id, &c);
			set_color(i, j, &c);
			clear_color(&c);
		}
	}

	//print_frame_info(startTime, finishTime, intersects_calced);
	intersects_calced = 0;
}
